//
//  ButtonPullDownPrepare.m
//  22222222222222
//
//  Created by liangchenying on 12-4-9.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "ButtonPullDownPrepare.h"

@implementation ButtonPullDownPrepare

@synthesize title               = _title;
@synthesize picker_view         = _picker_view;
@synthesize container_view      = _container_view;
@synthesize action_sheet        = _action_sheet;
@synthesize pop_over_controller = _pop_over_controller;
@synthesize self_reference      = _self_reference;

- (NSString*)title{
	if(_title == nil){
		_title = [[NSString alloc] init];
	}
	return _title;
}

- (UIActionSheet*)action_sheet{
	if(_action_sheet == nil){
		_action_sheet = [[UIActionSheet alloc] init];
   	}
    
	return _action_sheet;
}

- (id)initWithTarget:(id)origin  {
    self = [super init];
    
    if (self) {
        self.container_view = origin;
        self.self_reference = self;
    }
    
    return self;
}


- (void)dealloc {
    if ([self.picker_view respondsToSelector:@selector(setDelegate:)]) {
        [self.picker_view performSelector:@selector(setDelegate:)   withObject:nil];
    }
    
    if ([self.picker_view respondsToSelector:@selector(setDataSource:)]){
        [self.picker_view performSelector:@selector(setDataSource:) withObject:nil];
    }
    
    self.picker_view         = nil;
//    self.container_view      = nil;
//    self.action_sheet        = nil;
//    self.pop_over_controller = nil;

	
	[self.title release];	
	[self.container_view release];
	[self.action_sheet release];
	[self.picker_view release];
		
    [super dealloc];
}

- (void)showSheetPicker{
    UIView *sheet_picker_view = [[UIView alloc] init];

    UIToolbar *add_toolbar = [self createSheetPickerToolbarTitle:self.title];
    
    add_toolbar.barStyle = UIBarStyleBlackTranslucent;
  
    [sheet_picker_view addSubview:add_toolbar];
    
    self.picker_view = [self configuredPickerView];
    
    [sheet_picker_view addSubview:self.picker_view ];
    
    [sheet_picker_view setFrame:CGRectMake(0, 0, add_toolbar.frame.size.width, add_toolbar.frame.size.height + self.picker_view.frame.size.height)];
    
    [self presentPickerForView:sheet_picker_view];
	
    [sheet_picker_view release];
}

#pragma mark Abstract methods

- (UIView *)configuredPickerView{
    return nil;
}

- (void)notifyDoneTarget{
}

- (void)notifyCancelTarget{
}

#pragma mark -

- (UIToolbar *)createSheetPickerToolbarTitle:(NSString *)title  {
    CGFloat pickerWidth = 0;
    
    if (UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPhone) {
        pickerWidth = UIScreen.mainScreen.bounds.size.width;
    } else {
        pickerWidth = 320;
    }

    UIToolbar *add_toolbar = [[[UIToolbar alloc] initWithFrame:CGRectMake(0, 0, pickerWidth, 40)] autorelease];
    
    NSMutableArray *array_toolbar = [[NSMutableArray alloc] init];
    
    [array_toolbar addObject:[self createButton:UIBarButtonSystemItemCancel target:self action:@selector(actionPickerCancel:)]];
    
    [array_toolbar addObject:[self createToolbarTitle:self.title]];
    
    [array_toolbar addObject:[self createButton:UIBarButtonSystemItemDone target:self action:@selector(actionPickerDone:)]];
    
    [add_toolbar setItems:array_toolbar animated:YES];
    
    [array_toolbar release];
    
    return add_toolbar;
}

- (UIBarButtonItem *)createToolbarTitle:(NSString *)title {
    UILabel *toolbar_item = [[UILabel alloc]initWithFrame:CGRectMake(0, 0, 185, 40)];     // fixed width and height
    
    [toolbar_item setTextAlignment:NSTextAlignmentCenter];
    
    [toolbar_item setFont:[UIFont boldSystemFontOfSize:16]];
    
    toolbar_item.text = self.title;

    [toolbar_item setTextColor      :[UIColor whiteColor]];
    [toolbar_item setBackgroundColor:[UIColor clearColor]];
    
    
    UIBarButtonItem *button = [[[UIBarButtonItem alloc]initWithCustomView:toolbar_item] autorelease];
    
    [toolbar_item release];
    
    return button;
}

- (UIBarButtonItem *)createButton:(UIBarButtonSystemItem)type target:(id)target action:(SEL)buttonAction{
    return [[[UIBarButtonItem alloc] initWithBarButtonSystemItem:type target:target action:buttonAction] autorelease];
}

- (void)presentPickerForView:(UIView *)view {
    if (UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPhone){
        [self configureAndPresentActionSheetForView:view];
    }else{
        [self configureAndPresentPopoverForView    :view];
    }
}


- (void)configureAndPresentActionSheetForView:(UIView *)view{
    UIViewController *topController = UIApplication.sharedApplication.keyWindow.rootViewController;
    while (topController.presentedViewController) {
        topController = topController.presentedViewController;
    }
    
    // hide software keyboard
    UITextField *textField = [[UITextField alloc] init];
    [topController.view addSubview:textField];
    [textField becomeFirstResponder];
    [textField resignFirstResponder];
    [textField removeFromSuperview];
    [textField release];
    
    CGSize mainScreenSize = UIScreen.mainScreen.bounds.size;
    
    UIView *blockView = [[UIView alloc] initWithFrame:CGRectMake(0.0, 0.0, mainScreenSize.width, mainScreenSize.height)];
    blockView.backgroundColor = [UIColor grayColor];
    blockView.alpha = 0.7;
    self.blockView = blockView;
    [blockView release];
    
    UIView *subView = [[UIView alloc] initWithFrame:CGRectMake(0.0, mainScreenSize.height - view.frame.size.height, view.frame.size.width, view.frame.size.height)];
    subView.backgroundColor = UIColor.whiteColor;
    [subView addSubview:view];
    
    self.baseView = subView;
    [subView release];
    
    [topController.view addSubview:self.blockView];
    [topController.view addSubview:self.baseView];

   }

- (void)configureAndPresentPopoverForView:(UIView *)view {
    UIViewController *viewController = [[UIViewController alloc] init];
    
    viewController.view                        = view;
    int iOSMajorVersion = UIDevice.currentDevice.systemVersion.intValue;
    if (iOSMajorVersion >= 7) {
        viewController.preferredContentSize = view.frame.size;
    } else {
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
        viewController.contentSizeForViewInPopover = view.frame.size;
#pragma clang diagnostic pop
    }
    
    self.pop_over_controller = [[[UIPopoverController alloc] initWithContentViewController:viewController] autorelease];
	
    [self.pop_over_controller presentPopoverFromRect:self.container_view.superview.frame inView:self.container_view.superview permittedArrowDirections:0 animated:YES];
    
    [viewController release];
}

- (IBAction)actionPickerDone:(id)sender {
    [self notifyDoneButton];
    [self dismissPicker];
}

- (IBAction)actionPickerCancel:(id)sender {
    [self notifyCancelButton];
    [self dismissPicker];
}

- (void)dismissPicker {
    if (self.baseView) {
        [self.baseView removeFromSuperview];
    }
    
    if (self.blockView) {
        [self.blockView removeFromSuperview];
    }

    if (self.action_sheet) {
        if (self.action_sheet.isVisible) {
            [self.action_sheet dismissWithClickedButtonIndex:0 animated:YES];
        }
    }
    
    if (self.pop_over_controller){
        if (self.pop_over_controller.isPopoverVisible) {
            [self.pop_over_controller dismissPopoverAnimated:YES];
        }
    }
    self.action_sheet        = nil;
    self.pop_over_controller = nil;
    self.self_reference      = nil;
}

@end
